cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

global type tavg
global distance 2000


*Run at least once to produce smaller versions of the files to reduce load times for each type
use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw.$type.dta", clear
keep if year >= 2004
save "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw small.$type.dta", replace

use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN FLs.52j.$type.dta", clear
keep if year >= 2004
save "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN FLs.52j small.$type.dta", replace


use hcn_only_station_pairs_$distance.dta, clear

su station_pair_id
local max = r(max)

clear
tempfile results
cap gen date = 0
keep if _n < 0
sort date
save "`results'", replace

forvalues pair_id = 1(1)`max' {
	quietly {
	use hcn_only_station_pairs_$distance.dta, clear
	keep if station_pair_id == `pair_id'
	local station_id_1 = station_id_v1[1]
	local station_id_2 = station_id_v2[1]
	local distance = distance[1]
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw small.$type.dta", clear
	destring station_id, replace
	keep if station_id == `station_id_1'
	rename avg hcn_raw_1_$type
	keep hcn_raw_1_$type date
	drop if hcn_raw_1_$type == . | hcn_raw_1_$type == -9999
	sort date
	tempfile hcn_raw_1_results
	save "`hcn_raw_1_results'", replace
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw small.$type.dta", clear
	destring station_id, replace
	keep if station_id == `station_id_2'
	rename avg hcn_raw_2_$type
	keep hcn_raw_2_$type date
	drop if hcn_raw_2_$type == . | hcn_raw_2_$type == -9999
	sort date
	merge date using "`hcn_raw_1_results'"
	keep if _merge == 3
	drop _merge
	sort date	
	
	gen month = month(dofm(date))
	gen year = year(dofm(date))

	sort month	
	tempfile tempdata
	save "`tempdata'", replace

	collapse (mean) base_hcn_raw_1=hcn_raw_1_$type base_hcn_raw_2=hcn_raw_2_$type, by(month)
	sort month

	merge month using "`tempdata'"
	drop _merge
	replace hcn_raw_1_$type = hcn_raw_1_$type - base_hcn_raw_1
	replace hcn_raw_2_$type = hcn_raw_2_$type - base_hcn_raw_2
	
	gen raw_diff =  hcn_raw_1_$type - hcn_raw_2_$type
	
	sort date
	reg raw_diff date
	regsave using "`results'", ci append replace addlabel(dataset, $type, hcn_id_1, `station_id_1', hcn_id_2, `station_id_2', adjustments, raw, pair_id, `pair_id', distance, `distance')
	}
	display `pair_id'
}

use "`results'", clear
drop if var == "_cons"
replace coef = coef * 12.0
gen abs_coef = abs(coef)
save "hcn_only_raw_trends_diff $type $distance.dta", replace
